function [y]=simulate_OU_exact(params,w)


% Purpose: simulate the OU process with the exact discretization formula
% input: 3x1 vector of parameters, w: Tx1 vector of innovations
% output: Tx1 vector of OU process.

mu=params(1);  
sigma=params(2);
kappa=params(3);

% preallocate y
T=size(w,1); % number of elements
y=ones(T,1)*mu;


for j=2:T    
   y(j) = mu*(1-exp(-kappa))+exp(-kappa)*y(j-1)+sigma*w(j)*sqrt((1-exp(-2*kappa))/(2*kappa)); % exact formula
end
end